% 读取图像并进行裁剪工作
function ShowBiTIFF(TIFF)
%% 数据赋值
image = TIFF.cutrgb;
gasdata = TIFF.data;

%% PLOT1
figure('Position', [25 200 1400 600]);
subplot(121);
imshow(image, 'InitialMagnification', 'fit');
hold on
h = imagesc(gasdata);
% 找到 0 值的位置并设置为透明
zerosIndices = (gasdata == 0);
set(h, 'AlphaData', ~zerosIndices);
% 绘制排放源位置
plot(TIFF.rowIndex, TIFF.colIndex, 'g.','MarkerSize', 15);
% 坐标轴设置
axis square
axis tight;
% Colormap设置
caxis_max = 50;
caxis([0 caxis_max])
cmap = mycolorbar(2);
colormap(gca, cmap);  % 使用颜色映射
% colorbar;
%% PLOT2
subplot(122);
imshow(image, 'InitialMagnification', 'fit');
hold on
% 绘制排放源位置
plot(TIFF.rowIndex, TIFF.colIndex, 'g.','MarkerSize', 15);
hold off
%% 图名
title([TIFF.name,' ', TIFF.datestr]); % 图名
hold off

end