% 读取图像并进行裁剪工作
function TIFF = SelectPlumePosition(TIFF)
%% 数据赋值
image = TIFF.cutrgb;
gasdata = TIFF.maskdata;

%% 显示图像
figure('Position', [710 180 700 700]);
imshow(image, 'InitialMagnification', 'fit');
hold on
h = imagesc(gasdata);
axis square
axis tight;
axis on;

%
clim([0 min([80, max(TIFF.maskdata(:))])])
cmap = mycolorbar(0);
colormap(gca, cmap);  % 使用颜色映射
colorbar
% 找到 0 值的位置并设置为透明
zerosIndices = gasdata == 0;
set(h, 'AlphaData', ~zerosIndices);
% 绘制排放源位置
plot(TIFF.colIndex, TIFF.rowIndex, 'w.','MarkerSize', 15);

%%
[x, y, ~] = ginput(1); % 一次只获取一个点
TIFF.colIndex_new = x;
TIFF.rowIndex_new = y;

% 绘制排放源位置
plot(TIFF.colIndex_new, TIFF.rowIndex_new, 'r.','MarkerSize', 15);
end
