%% 导出裁剪后的羽流
function [cropped_tiff, plume_bounds] = SaveCroppedTiffData(TIFF, field, outtiffname)
tiffdata = TIFF.(field);
Refer = TIFF.R;
[row, col] = find(tiffdata); % 找到非零值的行和列索引
min_row = min(row); % 最小行索引
max_row = max(row); % 最大行索引
min_col = min(col); % 最小列索引
max_col = max(col); % 最大列索引
% 定义裁剪框
Rect = [min_col, min_row, max_col - min_col, max_row - min_row];
if(~isempty(Rect)) % 当裁剪范围非空的时候才会导出
    % 使用 imcrop 函数裁剪图像
    cropped_tiff = imcrop(tiffdata, Rect);
    % 修改地理参考
    lat1 = Refer.LatitudeLimits(2) - (max_row + TIFF.row0 - 2) * Refer.CellExtentInLatitude;
    lat2 = Refer.LatitudeLimits(2) - (min_row + TIFF.row0 - 2) * Refer.CellExtentInLatitude;
    lon1 = Refer.LongitudeLimits(1) + (min_col + TIFF.col0 - 2) * Refer.CellExtentInLongitude;
    lon2 = Refer.LongitudeLimits(1) + (max_col + TIFF.col0 - 2) * Refer.CellExtentInLongitude;
    Refer.LatitudeLimits = [lat1 lat2];
    Refer.LongitudeLimits = [lon1 lon2];
    Refer.RasterSize = size(cropped_tiff);
    geotiffwrite(outtiffname, cropped_tiff, Refer)
    plume_bounds = sprintf("[%.6f, %.6f, %.6f, %.6f]", Refer.LongitudeLimits(1), Refer.LatitudeLimits(1), Refer.LongitudeLimits(2), Refer.LatitudeLimits(2));

else
    cropped_tiff = [];
    plume_bounds = [];
end
end