%% 读取.raw格式文件
function [result] = Read_Raw(filename, col_num)
% 函数说明
% 读GF卫星的中心波长、半宽、辐射校正系数
fid = fopen(filename,'r');
FormatString = repmat('%f ',1, 2);
temp = textscan(fid, FormatString, 180, 'HeaderLines', 0, 'Delimiter', ',');
result = cell2mat(temp(:, 1 : col_num));
result = single(result); % 不损失精度
fclose(fid);
end