%% 读取swir文件
function swir_cut = ReadSWIR(datapath, flist, bandindex)
% 起止波段
bandnum = length(bandindex); % 波段数量
% 检查波段数据是否保存
issaved = false(bandnum, 1);
for i = 1 : bandnum
    band_filename =  fullfile(datapath, ['swir_', num2str(bandindex(i)),'.mat']);
    if(exist(band_filename, 'file')) % 如果存在该文件
        issaved(i) = true;
    end 
end
% 是否需要读取并保存数据
if(sum(issaved) == bandnum) % 如果所有的波段全都已经保存过
    % 则不需要再读取数据
else
    % 否则需要读取数据
    mydisp('正在读取SWIR数据...')
    swir = readgeoraster(flist.SWIR);
    mydisp('进行辐射矫正...')
    sw_rad_cal = Read_Raw(flist.swir_rad, 1); % 辐射校正系数 radiance calculation
    swir = Rad_Calibration(swir, sw_rad_cal); % 短波红外辐射定标
    for i = 1 : bandnum
        if(~issaved(i)) % 如果第i个波段的数据未保存过
            % 则需要读取
            swir_temp = swir(:, :, bandindex(i));
            band_filename =  fullfile(datapath, ['swir_', num2str(bandindex(i)),'.mat']);
            save(band_filename, 'swir_temp'); 
        end
    end
end
% 数据整合
swir_cut = [];
for i = 1 : bandnum
    band_filename =  fullfile(datapath, ['swir_', num2str(bandindex(i)),'.mat']);
    load(band_filename, 'swir_temp') % 从指定文件中加载指定变量
    swir_cut = cat(3, swir_cut, swir_temp);
end
end