%% 获取指定工作目录下的文件名称
function flist = ReadFiles(file_path)
flist.SWIR = dir([file_path,'\*SW.*tif*']);
flist.VNIR = dir([file_path,'\*VN.*tif*']);
flist.xml = dir([file_path,'\*.xml']);
% SWIR_FWHM和VNIR_FWHM有两种格式
flist.swir_fwhm = [dir([file_path,'\*SWIR_Spectralresponse.raw']); dir([file_path,'\*Spectralresponse_SWIR.raw'])];
flist.swir_rad = [dir([file_path,'\*SWIR_RadCal.raw']); dir([file_path,'\*RadCal_SWIR.raw'])];
flist.vnir_fwhm = [dir([file_path,'\*VNIR_Spectralresponse.raw']); dir([file_path,'\*Spectralresponse_VNIR.raw'])];
flist.vnir_rad = [dir([file_path,'\*VNIR_RadCal.raw']); dir([file_path,'\*RadCal_VNIR.raw'])];
flist.SWIR_rpb = dir([file_path,'\*SW.rpb']);
% 判断是否有文件不存在，如果不存在则返回空的 flist
if isempty(flist.SWIR) || isempty(flist.VNIR) || isempty(flist.xml) || ...
        isempty(flist.swir_fwhm) || isempty(flist.swir_rad) || ...
        isempty(flist.vnir_fwhm) || isempty(flist.vnir_rad) || isempty(flist.SWIR_rpb)
    flist = [];  % 返回空数组
else
    % 改为绝对路径
    flist.SWIR = fullfile(file_path, flist.SWIR.name);
    flist.VNIR = fullfile(file_path, flist.VNIR.name);
    flist.xml = fullfile(file_path, flist.xml.name);
    flist.swir_fwhm = fullfile(file_path, flist.swir_fwhm.name);
    flist.swir_rad = fullfile(file_path, flist.swir_rad.name);
    flist.vnir_fwhm = fullfile(file_path, flist.vnir_fwhm.name);
    flist.vnir_rad = fullfile(file_path, flist.vnir_rad.name);
    flist.SWIR_rpb = fullfile(file_path, flist.SWIR_rpb.name);
end
end