%% 读取swir（多波段）文件
function swir = ReadDataSWIR_ori(fpath, flist)
sw_file = fullfile(fpath, 'swir.mat'); % 完整文件的名称

if(exist(sw_file, 'file')) % 没有指定波段的SWIR数据，但是有完整的SWIR数据
    mydisp('正在读取SWIR数据...')
    load(sw_file, 'swir') % 从指定文件中加载指定变量
else % 没有任何数据
    mydisp('首次读取，正在读取数据...')
    swir = readgeoraster(flist.SWIR);
    mydisp('下面进行辐射矫正...')
    sw_rad_cal = Read_Raw(flist.swir_rad, 1); % 辐射校正系数 radiance calculation
    swir = Rad_Calibration(swir, sw_rad_cal); % 短波红外辐射定标
end
end