%% 读取swir文件
function swir_cut = ReadDataSWIR(datapath, flist, Gas)
wav1 = num2str(Gas.Band_wav1); % nm
wav2 = num2str(Gas.Band_wav2); % nm
sw_cut_filename = ['swir_', wav1, '_', wav2, '.mat'];
sw_cut_file = fullfile(datapath, sw_cut_filename); % 波段裁剪文件的名称
sw_file = fullfile(datapath, 'swir.mat'); % 完整文件的名称

if(exist(sw_cut_file, 'file'))
    mydisp('正在加载SWIR_CUT...')
    load(sw_cut_file, 'swir_cut') % 从指定文件中加载指定变量
else if(exist(sw_file, 'file')) % 没有指定波段的SWIR数据，但是有完整的SWIR数据
        mydisp('正在读取SWIR数据...')
        load(sw_file, 'swir') % 从指定文件中加载指定变量
    else % 没有任何数据
        mydisp('首次读取，正在读取数据...')
        swir = readgeoraster(flist.SWIR);
        mydisp('下面进行辐射矫正...')
        sw_rad_cal = Read_Raw(flist.swir_rad, 1); % 辐射校正系数 radiance calculation
        swir = Rad_Calibration(swir, sw_rad_cal); % 短波红外辐射定标
        %         mydisp('下面保存已校正的数据...')
        %         save(sw_file, 'swir');
        %         mydisp('已保存SWIR文件')
    end
    mydisp('正在提取指定波段的SWIR数据...')
    swir_cut = swir(:, :, Gas.bandindex);
    %     save(sw_cut_file, 'swir_cut');
    %     mydisp('已保存SWIR_CUT文件')
end
end