%% 读取rgb文件
function rgb = ReadDataRGB(fpath, flist, FWHM_VNIR)
rgb_file = fullfile(fpath, 'rgb.mat');

if(exist(rgb_file, 'file'))
    load(rgb_file, 'rgb')
else
    mydisp('正在读取VNIR数据...')
    vnir = readgeoraster(flist.VNIR);
    mydisp('进行辐射矫正处理...')
    vn_rad_cal = Read_Raw(flist.vnir_rad, 1); % 辐射校正系数
    vnir = Rad_Calibration(vnir, vn_rad_cal); % 可见光与近红外辐射定标
    % 获取RGB
    RGB_dst = [640, 550, 460]; % 红色640nm  绿色550nm   蓝色460nm
    RGB_index = GetWavIndex(FWHM_VNIR, RGB_dst);
    rgb = vnir(:, :, RGB_index);
    mydisp('保存已校正的RGB数据...')
    save(rgb_file, 'rgb');
    mydisp('已保存RGB文件')
end
end