%% 辐射矫正
function output = Rad_Calibration(input, rad_cal)
% input: swir短波红外 or vnir可见光与近红外
% rad_cal: 辐射校正系数
input = single(input); % 用single存储AHSI不会掉精度
[row, col, wav] = size(input);
input = reshape(input, row * col, wav); % 便于进行辐射定标
input = input .* repmat(rad_cal(:, 1)', row * col, 1); % 辐射定标操作
output = reshape(input, row, col, wav); % 尺寸复原
end