%% 获取风速相关信息
function Wind = GetWindData(filename_wind, Facility)
Wind.lon = ncread(filename_wind,'lon');
Wind.lat = ncread(filename_wind,'lat');
Wind.u10 = ncread(filename_wind,'U10M');
Wind.v10 = ncread(filename_wind,'V10M');
finfo_u = ncinfo(filename_wind);
% 风速的时间从00:30开始，每间隔一小时记录一个数据
Wind.time = Facility.time + duration(0, 30, 0); % 先加30分钟
Wind.time = dateshift(Wind.time, 'start', 'hour', 'nearest'); % 再偏移到最近的小时
time_index = hour(Wind.time); % 取其小时数作为时间的索引
lon_index = find_nearest_index(Wind.lon, Facility.lon);    % 获取位置的索引
lat_index = find_nearest_index(Wind.lat, Facility.lat);
% 提取当前位置与时间的风速数据
Wind.u10_ = Wind.u10(lon_index, lat_index, time_index);
Wind.v10_ = Wind.v10(lon_index, lat_index, time_index);
% 计算实际风速和有效风速
Wind.speed = sqrt(Wind.u10_^2 + Wind.v10_^2); % 风速
Wind.direction = atan2d(Wind.v10_, Wind.u10_); % 风向
Wind.direction = mod((Wind.direction + 360), 360);
% Ueff：有效风速 effective wind speed
Wind.Ueff = 0.34 * Wind.speed + 0.44; % 单位：m/s
end
