%% 获得波段索引区间
function output = GetWavIndexes(FWHM, Gas)
% FWHM 变量: 包含中心波长
% dst: 待寻找的目标波长
% output: 返回与目标波长相匹配的FWHM中心波长的索引，
dst1 = Gas.Band_wav1;
dst2 = Gas.Band_wav2;
center_wavelength = FWHM(:, 1);
temp1 = abs(dst1 - center_wavelength);
[~, output1] = min(temp1); % 寻找与目标波长最接近的波段
temp2 = abs(dst2 - center_wavelength);
[~, output2] = min(temp2); % 寻找与目标波长最接近的波段
output = output1 : output2;
end