%% 获得波段索引
function output = GetWavIndex(FWHM, dst)
% FWHM 变量: 包含中心波长
% dst: 待寻找的目标波长
% output: 返回与目标波长相匹配的FWHM中心波长的索引，
center_wavelength = FWHM(:,1);
temp = abs(dst - center_wavelength);
[~, output] = min(temp); % 寻找与目标波长最接近的波段
end