%% 获取大气质量相关信息
function VMA = GetVMAData(filename_VMA, Item)
% 获取 NetCDF 文件的信息
fileInfo = ncinfo(filename_VMA);
VMA.alldata = ncread(filename_VMA,'p53.162');  % in kg m-2   Vertical integral of mass of atmosphere
VMA.lon = ncread(filename_VMA,'longitude');
VMA.lat = ncread(filename_VMA,'latitude');

% 定义可能的时间字段名称
timeVarNames = {'time', 'valid_time'};
VMA.time = [];

% 检查并读取时间字段
for i = 1:length(timeVarNames)
    varName = timeVarNames{i};

    % 检查变量名是否存在于文件的变量列表中
    if any(strcmp({fileInfo.Variables.Name}, varName))
        try
            VMA.time = ncread(filename_VMA, varName);
            disp(['Successfully read the time variable: ', varName]);
            break; % 成功读取后退出循环
        catch ME
            warning('Failed to read the ''%s'' variable: %s', varName, ME.message);
        end
    end
end
%% 读取NC文件的时间信息
% 打开 NetCDF 文件
ncid = netcdf.open(filename_VMA, 'NOWRITE');
% 检查并读取时间字段
for i = 1:length(timeVarNames)
    varName = timeVarNames{i};
    try
        varid = netcdf.inqVarID(ncid, varName); % 获取 'valid_time' 变量的ID（假设该变量存在）
        % 检查是否成功找到变量
        if isequal(varid, -1)
            disp('未能找到变量 "valid_time"');
        else
            % 获取 'units' 属性的值
            units = netcdf.getAtt(ncid, varid, 'units');
            % 显示 'units' 属性值
            disp(['valid_time 的 units 属性值为: ', units]);
        end
    catch ME
        % disp(ME.message);
    end
end
% 关闭 NetCDF 文件
netcdf.close(ncid);
%%
if(strcmp(units, 'hours since 1900-01-01 00:00:00.0'))
    VMA.time = datetime('1900-01-01 00:00:00') + hours(VMA.time);    % 将小时数转换为日期时间
elseif(strcmp(units, 'seconds since 1970-01-01'))
    VMA.time = datetime('1970-01-01 00:00:00') + seconds(VMA.time);    % 将小时数转换为日期时间
end

% 寻找最近邻元
lon_ind = find_nearest_index(VMA.lon, Item.longitude);
lat_ind = find_nearest_index(VMA.lat, Item.latitude);
time_ind = find_nearest_index(VMA.time, Item.datetime);
% 插值
X = double(VMA.lon);
Y = double(VMA.lat);
Z = datenum(VMA.time);
V = VMA.alldata;
Xq = Item.longitude;
Yq = Item.latitude;
Zq = datenum(Item.datetime);
if(length(Z)>1)
    %     Vq1 = interp3(X,Y,Z,V,Xq,Yq,Zq,'cubic');
    Vq2 = interp3(X,Y,Z,V,Xq,Yq,Zq,'linear');
    %     Vq3 = interp3(X,Y,Z,V,Xq,Yq,Zq,'spline');
    %     Vq4 = interp3(X,Y,Z,V,Xq,Yq,Zq,'makima');
    %     Vq_list = [Vq1, Vq2, Vq3, Vq4];
    %     Vq = nanmean(Vq_list);
    Vq = Vq2;
    %     Vq_Uncertainty = nanstd(Vq_list);
else
    Vq = NaN;
end
% figure
% [X,Y,Z]=meshgrid(X,Y,Z)
% slice(X,Y,Z,V,Xq,Yq,Zq);
% shading flat

VMA.data = VMA.alldata(lon_ind, lat_ind, time_ind); % 时间和经纬度配准的结果
if(isnan(Vq)) %
    disp('请检查VMA数据一致性')
    VMA.interpdata = VMA.data;
else
    VMA.interpdata = Vq;
end
end