%% 获取TIFF反演信息
function TIFF = GetTIFFData1(tifname_res, Facility, range)
%% 基本信息
TIFF.foldername = Facility.foldername; % 子文件夹名称
TIFF.name = Facility.name; % 设施名称
TIFF.datestr = TIFF.foldername(end - 7 : end); % 日期名称
[TIFF_oridata, TIFF.R] = readgeoraster(tifname_res); % 单位：ppb = 10e-6
TIFF_gasdata = TIFF_oridata(:,:,4);
TIFF_rgb = TIFF_oridata(:,:,1:3);
TIFF_rgb = TIFF_rgb / 256;
TIFF_rgb_s = ImgStretch(TIFF_rgb, 0.5, 99.5);
TIFF.unit_length = 30;   % 栅格单位长度（m）
[TIFF_lat,TIFF_lon] = geographicGrid(TIFF.R);

%% 查找排放源坐标
lat = Facility.lat;
lon = Facility.lon;
matrix = (TIFF_lat - lat).^2 + (TIFF_lon - lon).^2;
[~, linearIndex] = min(matrix(:));
[rowIndex, colIndex] = ind2sub(size(matrix), linearIndex);
% mydisp(sprintf("行索引：%d 列索引：%d", rowIndex, colIndex));

%% 裁剪范围
rindexs = rowIndex - range + 1: rowIndex + range;
cindexs = colIndex - range + 1: colIndex + range;
TIFF.rowIndex = range;
TIFF.colIndex = range;
TIFF.cutdata = TIFF_gasdata(rindexs, cindexs);
TIFF.cutrgb = TIFF_rgb_s(rindexs, cindexs, :);
TIFF.row0 = rowIndex - range + 1; % 最上侧
TIFF.col0 = colIndex - range + 1; % 最左侧
%%
mydisp("TIFF数据获取完成");
end
