%% 获取TIFF反演信息
function TIFF = GetTIFFData(Item, PARM_CROP)
%% 基本信息
if(exist(Item.tiffname.RMF_cor, 'file') && exist(Item.tiffname.RGB_cor, 'file'))
    tifname_res = Item.tiffname.RMF_cor;
    tiffname_RGB = Item.tiffname.RGB_cor;
    fprintf("已使用手动校正结果。\n")
elseif(exist(Item.tiffname.RMF, 'file') && exist(Item.tiffname.RGB, 'file'))
    tifname_res = Item.tiffname.RMF;
    tiffname_RGB = Item.tiffname.RGB;
else
    fprintf("反演结果与RGB文件不存在！\n");
    return;
end
TIFF.foldername = Item.foldername; % 子文件夹名称
TIFF.name = Item.facility; % 设施名称
TIFF.datestr = Item.date; % 日期名称
[TIFF_gasdata, TIFF.R] = readgeoraster(tifname_res); % 单位：ppb = 10e-6
[TIFF_rgb_s, TIFF.R] = readgeoraster(tiffname_RGB);

[TIFF_lat, TIFF_lon] = geographicGrid(TIFF.R);
mean_lat = mean(TIFF.R.LatitudeLimits);
mean_lon = mean(TIFF.R.LongitudeLimits);
lat_dis = haversine(mean_lat, mean_lon, mean_lat+1, mean_lon) * 1e3; % m/°
lon_dis = haversine(mean_lat, mean_lon, mean_lat, mean_lon+1) * 1e3; % m/°
TIFF.unit_length_lat = lat_dis * TIFF.R.CellExtentInLatitude;
TIFF.unit_length_lon = lon_dis * TIFF.R.CellExtentInLongitude;
TIFF.unit_length = sqrt(TIFF.unit_length_lat * TIFF.unit_length_lon);
%% 查找排放源坐标
lat = Item.latitude;
lon = Item.longitude;
matrix = (TIFF_lat - lat).^2 + (TIFF_lon - lon).^2;
[~, linearIndex] = min(matrix(:));
[rowIndex, colIndex] = ind2sub(size(matrix), linearIndex);
% mydisp(sprintf("行索引：%d 列索引：%d", rowIndex, colIndex));

%% 裁剪范围
[ROW, COL] = size(TIFF_gasdata);
rindexs = max(1, rowIndex - PARM_CROP.range + 1): min(rowIndex + PARM_CROP.range, ROW);
cindexs = max(1, colIndex - PARM_CROP.range + 1): min(colIndex + PARM_CROP.range, COL);

TIFF.cutdata = TIFF_gasdata(rindexs, cindexs);
TIFF.cutrgb = TIFF_rgb_s(rindexs, cindexs, :);
TIFF.row0 = max(1, rowIndex - PARM_CROP.range + 1); % 最上侧
TIFF.col0 = max(1, colIndex - PARM_CROP.range + 1); % 最左侧
TIFF.rowIndex = rowIndex - TIFF.row0 + 1;
TIFF.colIndex = colIndex - TIFF.col0 + 1;
%%
% mydisp("TIFF数据获取完成");
end
