%% 从CertainBand.xlsx文件中读取波段数
function bandindex = GetBandIndex(Tabledata, Satellite, FWHM_SWIR)
bandindex = [];
%% 确定波段类型
index = find(strcmp(Tabledata{:,1}, Satellite));
for j = 1:4
    Gas.Band_wav1 = Tabledata{index,3*j-1}; % nm 起始波段
    if(Gas.Band_wav1 == -1)
        continue;
    end
    Gas.Band_wav2 = Tabledata{index,3*j}; % nm 终止波段
    cellstr = cell2mat(Tabledata{index,3*j+1}); % 待去除的波段
    Gas.bandindex = GetWavIndexes(FWHM_SWIR, Gas);
    if(~strcmp(cellstr,"")) % 需要去除中间波段
        deleteband = reshape(str2double(split(cellstr,',')), 1, []);
        Gas.bandindex(deleteband) = [];
    end
    bandindex = [bandindex, Gas.bandindex];
end
end