%% 读取水汽透过率
function WV = ReadDataWaterVapor(fpath, flist, FWHM_VNIR)
WV_file = fullfile(fpath, 'WV.mat');
if(exist(WV_file, 'file'))
    load(WV_file, 'WV')
else
    mydisp('正在读取VNIR数据...')
    vnir = readgeoraster(flist.VNIR);
    mydisp('进行辐射矫正处理...')
    vn_rad_cal = Read_Raw(flist.vnir_rad, 1); % 辐射校正系数
    vnir = Rad_Calibration(vnir, vn_rad_cal); % 可见光与近红外辐射定标
    % 获取WV
    WV_dst = [935, 870]; % 935nm / 870nm
    WV_index = GetWavIndex(FWHM_VNIR, WV_dst);
    WV_data = vnir(:, :, WV_index);
    WV = WV_data(:,:,1) ./ WV_data(:,:,2);
    save(WV_file, 'WV');
    mydisp('已保存Water Vapor文件')
end
end