function rho = Radiance2Reflectance(Radiance, xmlStruct, Esun)
% 辐射亮度转换为表观反射率
%% 数据准备
date = datetime(xmlStruct.StartTime);
Day1 = juliandate(date);
Day2 = juliandate(datetime(year(date), 1, 1));
Days = Day1 - Day2;
D = (1 + 0.0167 * sin(2 * pi * (Days - 93.5) / 365)); % 日地平均距离（天文单位）
Esun = reshape(Esun, 1, 1, []);
Esun = repmat(Esun, size(Radiance, 1) , size(Radiance, 2));
SolarZenith = str2double(xmlStruct.SolarZenith); % 太阳天顶角

%% 转换公式
rho = (pi * Radiance * D^2) ./ (Esun * cos(pi * SolarZenith / 180)); % rho为大气顶层的表观反射率(各像素，各波段)
end