function TIFF = ProcessTIFFdata(merge, Item, flist, range)
%% 基本信息
TIFF.foldername = Item.foldername; % 子文件夹名称
TIFF.name = Item.facility; % 设施名称
TIFF.datestr = TIFF.foldername(end - 7 : end); % 日期名称
TIFF.oridata = merge; % 单位：ppb = 10e-6
rgb = TIFF.oridata(:,:,1:3); % 前三个波段为RGB
TIFF.rgb = rgb / 256;
TIFF.rgb_s = ImgStretch(TIFF.rgb, 0.5, 99.5); % 拉伸RGB色彩
TIFF.gasdata = TIFF.oridata(:,:,4); % 取第四波段 (ppm)
TIFF.unit_length = 30;   % 栅格单位长度（m）
[ROW, COL, ~] = size(TIFF.oridata);
%% 查找排放源坐标
lat = Item.lat;
lon = Item.lon;
llh = [lat, lon, 0];
pixel_position = RS_read_rpb(flist.SWIR_rpb, llh);
rowIndex = round(pixel_position(1));
colIndex = round(pixel_position(2));
mydisp(sprintf("行索引：%d 列索引：%d", rowIndex, colIndex));
TIFF.ROWIND = rowIndex; % 绝对索引
TIFF.COLIND = colIndex;
%% 裁剪范围
if(rowIndex - range + 1 <= 0)
    r1 = 1;
    TIFF.rowIndex = rowIndex; % 排放源行绝对索引
else
    r1 = rowIndex - range + 1;
    TIFF.rowIndex = range;
end
if(rowIndex + range >= ROW)
    r2 = ROW;
else
    r2 = rowIndex + range;
end
rindexs = r1:r2;
if(colIndex - range + 1 <= 0)
    c1 = 1;
    TIFF.colIndex = colIndex; % 排放源列绝对索引
else
    c1 = colIndex - range + 1;
    TIFF.colIndex = range;
end
if(colIndex + range >= COL)
    c2 = COL;
else
    c2 = colIndex + range;
end
cindexs = c1:c2;
TIFF.cutdata = TIFF.gasdata(rindexs, cindexs);
TIFF.cutrgb = TIFF.rgb_s(rindexs, cindexs, :);
%% 二值提取
% 设定阈值，将 res_cut 转换为二值图像
% emission = TIFF.cutdata > 0; % 大于0就视作有排放
% labeled_image = bwlabel(emission, 8); % 使用 8-邻域连接法则标记连通区域
% region_props = regionprops(labeled_image, 'Area'); % 获取各个区域的像素数目
% % 仅保留像素数目达到 thresh 个的部分
% TIFF.mask = ismember(labeled_image, find([region_props.Area] >= thresh));
% while(sum(TIFF.mask(:)) == 0 && thresh >= 0) % 如果没有符合条件的
%     thresh = thresh - 4;
%     TIFF.mask = ismember(labeled_image, find([region_props.Area] >= thresh));
% end
% TIFF.data = TIFF.cutdata .* TIFF.mask; % 筛选结果
TIFF.data = TIFF.cutdata;
%% 合并
TIFF.mergedata = cat(3, TIFF.rgb_s, TIFF.gasdata);
end