function PrintBasicInfo(Item)
disp('————————————————————————')
mydisp("基本信息");
fprintf('序号: ');cprintf('*black',[num2str(Item.id),'\n']);
disp(['设施: ',Item.facility]);
disp(['数据: ',Item.filename]);
disp(['时间: ', datestr(Item.datetime, 'yyyy-mm-ddThh:MM:ssZ')])
disp(['坐标: [',num2str(Item.latitude), ',', num2str(Item.longitude),']']);

if(~isnan(Item.emission_epa))
    fprintf('强度: '); cprintf('*blue','%.2f(t/h)\n', Item.emission_epa);
end

fprintf('质量: ');
if(Item.plume_quality == 1)
    cprintf('*green', [Item.plume_quality_label, '\n']);
elseif(Item.plume_quality == 0.7)
    cprintf([1, 0.5, 0], [Item.plume_quality_label, '\n']);
elseif(Item.plume_quality == 0.5)
    cprintf('*yellow', [Item.plume_quality_label, '\n']);
elseif(Item.plume_quality ==0)
    cprintf('*red', [Item.plume_quality_label, '\n']);
elseif(Item.plume_quality == -1)
    cprintf('*blue', [Item.plume_quality_label, '\n']);
else
    cprintf('*black', [Item.plume_quality_label, '\n']);
end
end