function Plot_scatter_all(T, outputfolder)
close all;
removed_img = T.plume_quality < 0.7;
EPA_data_plot = T.emission_epa; EPA_data_plot(removed_img, :) = [];
Emission_plot = T.emission; Emission_plot(removed_img, :) = [];
Emission_uncertainty_plot = T.emission_uncertainty; Emission_uncertainty_plot(removed_img, :) = [];
Platform_plot = string(T.platform); Platform_plot(removed_img, :) = [];
idx = Platform_plot == 'GF5A' | Platform_plot == 'GF5B' | Platform_plot == 'GF5';
%
f1 = figure('Position', [10 50 800 800]);
Plot_scatter(EPA_data_plot, Emission_plot, Emission_uncertainty_plot, idx);
%
f2 = figure('Position', [650 350 500 500]);
Plot_scatter_GF(EPA_data_plot(idx), Emission_plot(idx), Emission_uncertainty_plot(idx), Platform_plot(idx, :));
%
f3 = figure('Position', [1000 350 500 500]);
Plot_scatter_ZY(EPA_data_plot(~idx), Emission_plot(~idx), Emission_uncertainty_plot(~idx), Platform_plot(~idx, :));
%
f4 = figure('Position', [600 50 1200 300]);
plotbar(Emission_plot, Emission_uncertainty_plot, Platform_plot);
print(f1, [outputfolder, '\f1'],'-dpng','-r600');
print(f2, [outputfolder, '\f2'],'-dpng','-r600');
print(f3, [outputfolder, '\f3'],'-dpng','-r600');
print(f4, [outputfolder, '\f4'],'-dpng','-r600');
end