function Plot_scatter_GF(x, y, y_error, satellite)
%% 散点图
hold on
Fontname = 'Arial';
fontsize = 14;
%% 初始化标注变量
GF5_labeled = false;
GF5A_labeled = false;
GF5B_labeled = false;
%% 绘制散点
for i = 1:size(satellite, 1)
    % 根据 class 参数选择颜色
    if strcmp(satellite(i,:), 'GF5')
        color = [220,10,80]/255;
        series_name = 'GF5';
    elseif strcmp(satellite(i,:), 'GF5A')
        color = [192,50,26]/255;
        series_name = 'GF5A';
    elseif strcmp(satellite(i,:), 'GF5B')
        color = [221,124,79]/255;
        series_name = 'GF5B';
    else
        disp(satellite)
    end
    
    %     检查是否已经标注过
    if strcmp(satellite(i,:),'GF5 ')
        if(~GF5_labeled)
            h = scatter(x(i), y(i), 50, color, '^', 'filled','MarkerEdgeColor', 'k', 'DisplayName', series_name);
            GF5_labeled = true;
        else
            h = scatter(x(i), y(i), 50, color, '^', 'filled','MarkerEdgeColor', 'k', 'DisplayName', series_name);
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    elseif strcmp(satellite(i,:),'GF5A')
        if(~GF5A_labeled)
            h = scatter(x(i), y(i), 50, color, 'd', 'filled','MarkerEdgeColor', 'k', 'DisplayName', series_name);
            GF5A_labeled = true;
        else
            h = scatter(x(i), y(i), 50, color, 'd', 'filled','MarkerEdgeColor', 'k', 'DisplayName', series_name);
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    elseif strcmp(satellite(i,:),'GF5B')
        if(~GF5B_labeled)
            h = scatter(x(i), y(i), 50, color, 'filled','MarkerEdgeColor', 'k', 'DisplayName', series_name);
            GF5B_labeled = true;
        else
            h = scatter(x(i), y(i), 50, color, 'filled','MarkerEdgeColor', 'k', 'DisplayName', series_name);
            set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
        end
    end
    
    % 添加误差线
    h = errorbar(x(i), y(i), y_error(i), 'LineStyle', 'none', 'Color', color);
    set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');
end

% 添加辅助线
h = plot([0,1e5],[0,1e5],'k--','LineWidth',1);% 1-1线
set(get(get(h, 'Annotation'), 'LegendInformation'), 'IconDisplayStyle', 'off');

%% 添加坐标轴标题
xtitle = 'EPA CO_2 emission rate (t·h^{-1})';
ytitle = 'AHSI CO_2 emission rate (t·h^{-1})';
xlabel(xtitle, 'FontName', Fontname,'FontWeight','bold','FontSize',fontsize);
ylabel(ytitle, 'FontName', Fontname,'FontWeight','bold','FontSize',fontsize);

%% 设置坐标轴
max = 3200;
set(gca,'Xlim',[0, max],'Ylim',[0, max]);
set(gca,'xminortick','on');
set(gca,'yminortick','on');
set(gca,'XTick',(0:800:max),'YTick',(0:800:max));
ax = gca;
ax.XAxis.MinorTickValues = 0:100:max;
ax.YAxis.MinorTickValues = 0:100:max;

%% 添加图例
legend('show', 'Location', 'southeast');

%% 计算评估指标
ME = sum(y - x) / length(x);
ME_rate = ME / mean(x);
MAE = sum(abs(y-x))/length(x);
MAE_rate = MAE / mean(x);
RMSE = sqrt(sum((y-x).^2)/length(x));
RMSE_rate = RMSE / mean(x);
R_mat = corrcoef(x, y);
R = R_mat(1, 2); % 相关系数
text('Position',[100/3000*max,max-100/3000*max],'String',['ME =  ',num2str(ME,'%.2f'), ' (', num2str(100 * ME_rate, '%.2f'), '%)'],'FontName',Fontname,'fontsize',fontsize,'FontWeight','bold');
text('Position',[100/3000*max,max-300/3000*max],'String',['MAE =  ',num2str(MAE,'%.2f'), ' (', num2str(100 * MAE_rate, '%.2f'), '%)'],'FontName',Fontname,'fontsize',fontsize,'FontWeight','bold');
text('Position',[100/3000*max,max-500/3000*max],'String',['RMSE = ',num2str(RMSE,'%.2f'), ' (', num2str(100 * RMSE_rate, '%.2f'), '%)'],'FontName',Fontname,'fontsize',fontsize,'FontWeight','bold');
text('Position',[100/3000*max,max-700/3000*max],'String',['N = ',num2str(length(x)),', R = ',num2str(R, '%.4f')],'FontName',Fontname,'fontsize',fontsize,'FontWeight','bold');
%
set(gca,'box','on')
set(gca,'FontName', Fontname,'FontSize',fontsize,'FontWeight','bold','LineWidth',1);
axis square
hold off
end
