function fig = PlotProfile(Item, TIFF_5, Wind, pan_img, stat)
% 创建一个新的Figure窗口
fig_set.width = 1300;
fig_set.height = 900;
Satellite_str = ['Platform: ', Item.platform];
Location_str = ['Location: [', num2str(Item.latitude), ', ', num2str(Item.longitude),']'];
Date_str = ['Date: ' ,Item.date];
Plume_quality_str = ['Quality: ', Item.plume_quality_label];
%% 创建图窗
fig = figure('Position', [100 100 fig_set.width fig_set.height]);
%% 子图1
ax1 = axes('Position', [100/fig_set.width 100/fig_set.height 700/fig_set.width 700/fig_set.height]); % [left, bottom, width, height]
ShowImage(TIFF_5.cutrgb, TIFF_5.gaussiandata, "");
ylims = get(gca, 'YLim');
xlims = get(gca, 'XLim');
% 定义文本位置偏移量
y_offset = 0.05 * ylims(2);
x_pos = 0.05 * xlims(2); % 所有文本的左边缘位置
% 预估一个足够大的宽度以容纳最长的文本行（这里用相对坐标表示）
estimated_width = 0.45; % 作为示例，可以根据实际情况调整
% 创建文本标签，并为每个标签添加一个半透明白色的矩形背景
text_items = {Item.facility, Satellite_str, Location_str, Date_str, Item.emission_str, Item.extract_str, Plume_quality_str};
for j = 1:length(text_items)
    text_item = text_items{j};
    % 添加矩形背景（半透明）
    rectangle('Position', [x_pos - 0.02*xlims(2), y_offset + (j-1)*0.05*ylims(2) - 0.02*ylims(2), ...
        estimated_width*xlims(2), 0.04*ylims(2)], 'FaceColor', [0.9 0.9 0.9], 'EdgeColor', 'none', 'FaceAlpha', 0.5);
    % 添加文本
    hText = text(x_pos, y_offset + (j-1)*0.05*ylims(2), text_item, 'FontSize', 14, 'FontName', 'Arial');
    % 确保文本在矩形之上
    uistack(hText, 'top');
end
% 添加并配置colorbar
cb = colorbar(ax1, 'south');
cb.Label.String = '\DeltaXCO_2 (ppm)'; % 使用LaTeX语法表示δ
cb.Label.FontName = 'Arial';

clim([0 max(TIFF_5.gaussiandata(:))]);
% 设置colorbar文本标签的颜色、字体和大小
set(cb, 'FontName', 'Arial', 'FontSize', 14);
clim([0 max(TIFF_5.gaussiandata(:))])

%% 子图2
ax2 = polaraxes('Position', [900/fig_set.width 100/fig_set.height 300/fig_set.width 300/fig_set.height]); % [left, bottom, width, height]
PlotWind(Wind);
%% 子图3
ax3 = axes('Position', [900/fig_set.width 500/fig_set.height 300/fig_set.width 300/fig_set.height]); % [left, bottom, width, height]
plotRGBMeanHistogram(pan_img, stat);
end