function plumemask_thresh = NeighMask(plumemask, thresh)
% 使用二值图像标记连通区域
labeled_image = bwlabel(plumemask, 8); % 使用 8邻域连接法则标记连通区域
region_props = regionprops(labeled_image, 'Area'); % 获取各个区域的像素数目
% 仅保留像素数目达到 thresh 个的部分
plumemask_thresh = ismember(labeled_image, find([region_props.Area] >= thresh));
end