function merge = MergeData(rgb, result)
%% 波段合并（红绿蓝波段导出）
[row1, col1] = size(rgb, [1 2]);
[row2, col2] = size(result, [1 2]);
if(row1 ~= row2 || col1 ~= col2)
    mydisp('VNIR与SWIR尺寸不同');
    mydisp(sprintf('VNIR: [%d, %d]', row1, col1));
    mydisp(sprintf('SWIR: [%d, %d]', row2, col2));
    row = min([row1 row2]);
    col = min([col1 col2]);
    rgb = rgb(1:row, 1:col, :);
    result = result(1:row, 1:col, :);
end
merge = cat(3, rgb, result); % 通道合并
end