% Version: 1.0
% Reviser: Huayiwang
% Feature: Classic Matched Filter
% Date: 2024-4-26

function result = CMF(swir, s)
result = zeros(size(swir, [1 2]));
for j = 1 : size(swir, 2) % 按列进行处理
    L = swir(:, j, :); % 取出一列元素
    L = squeeze(L); % 去除列向量层级，变为行*波段
    alpha = Filter(L, s);
    result(:, j) = alpha; % 取最后一次迭代结果
end
end

%%
function alpha = Filter(L, s)
%% 初始化
mu = trimmean(L, 10)'; % 波段数 * 1
C = cov(L); % 波段数 * 波段数
%% Albedo Factor
tempA = mu .* s; % 8 * 1
tempC = pinv(C) * tempA; % 8 * 1
tempB = mu - L'; % 8 * 2056
alpha = tempB' * tempC ./ (tempA' * tempC);
alpha(alpha < 0) = 0;
end