%% 反演碳浓度的主函数
function [flist, k_CO2, result_CO2] = MainInvCarbon(origin_file_path, result_file_path, Gas)
flist = ReadFiles(origin_file_path); % 读取数据
%% 数据读取与辐射矫正
xmlStruct = ReadXmlData(flist.xml);   % 读取xml文件
FWHM_SWIR = Read_Raw(flist.swir_fwhm, 2);% FWHM 包含central wavelength 中心波长 和 full width at half maxima 半宽
% 计算波段起始值
band_start = GetWavIndex(FWHM_SWIR, Gas.Band_wav1);
band_end = GetWavIndex(FWHM_SWIR, Gas.Band_wav2);
Gas.bandindex = band_start:band_end;
% 主数据SWIR
datapath = fullfile(result_file_path, 'INPUT'); % 输入数据路径
if(~exist(datapath, 'dir')) % 如果不存在output文件夹
    mkdir(datapath) % 新建文件夹
end
swir_cut = ReadDataSWIR(datapath, flist, Gas); % 读取SWIR
%% 计算k值
SolarZenith = str2double(xmlStruct.SolarZenith); % 太阳天顶角
SolarAzimuth = str2double(xmlStruct.SolarAzimuth); % 太阳方位角
MON = month(str2date(xmlStruct.StartTime));
FWHM_Gas = FWHM_SWIR(Gas.bandindex, :);
k_CO2 = calc_k(FWHM_Gas, Gas, MON, SolarAzimuth, SolarZenith);
% k_H2O = calc_k(FWHM_Gas, Gas, MON, SolarAzimuth, SolarZenith);
mydisp("k值计算完成");
clear zenith amf
%% 匹配滤波算法
result_CO2 = RMF(swir_cut, k_CO2);
mydisp("匹配滤波完成");
clear band_start band_end
end