%% 计算排放速度的主函数
function [VMA, Wind] = MainFunctionIME(Item)
%% 获取名称
% 大气质量垂直积分(vertical_mass_of_atmosphere, VMA) ERA5 single level
filename_VMA = dir([Item.path.result_path, '\*SL.nc']); % https://cds.climate.copernicus.eu/cdsapp#!/dataset/reanalysis-era5-single-levels?tab=form
file_VMA = fullfile(Item.path.result_path, filename_VMA(1).name);
% 风速数据 ERA5 Pressure level
% filename_wind = dir([filepath, '\*PL.nc']); % https://cds.climate.copernicus.eu/cdsapp#!/dataset/reanalysis-era5-single-levels?tab=form
% file_wind = fullfile(filepath, filename_wind.name);
% NASA风速数据（历史版本，暂时弃用） %[lon:lat=360:180@0.625:0.5]
% filename_wind = dir([filepath, '\*.nc4']);
% file_wind = fullfile(filepath, filename_wind.name); % 下载：https://disc.gsfc.nasa.gov/datasets/M2T1NXSLV_5.12.4/summary

%% 大气质量的垂直积分(vertical_mass_of_atmosphere, VMA) 空间分辨率为0.25°
if(~isempty(filename_VMA))
    VMA = GetVMAData(file_VMA, Item);
else
    VMA.interpdata = 9e3;
    disp('尚未下载VMA数据！')
end
%% 读取风速数据
choice = 3;
SurfacePressure_filename = fullfile(Item.path.result_path, ['WindStruct_', num2str(choice), '.mat']);
if(~exist(SurfacePressure_filename, 'file'))
    % Wind = WebWindData(Item, choice);
    wind_struct_data = WebWindStructData(Item, choice);
    save(SurfacePressure_filename, 'wind_struct_data');
    mydisp('正在保存风速STRUCT数据!');
else
    load(SurfacePressure_filename, 'wind_struct_data');
end
%% 解析STRUCT数据
Wind_speed = wind_struct_data.hourly.wind_speed_10m;
Wind_direction= wind_struct_data.hourly.wind_direction_10m;
%
Hour = hour(Item.datetime);
Minute = minute(Item.datetime);
index = round(Hour + (Minute / 60)) + 1;
Wind.speed = Wind_speed(index);
Wind.speed_std = std(Wind_speed(index-1:index+1));
Wind.direction = Wind_direction(index);
Wind.direction_std = std(Wind_direction(index-1:index+1));
Wind.u10_ = Wind.speed * sind(Wind.direction);
Wind.v10_ = Wind.speed * cosd(Wind.direction);
Wind.lat = wind_struct_data.latitude;
Wind.lon = wind_struct_data.longitude;
%% Ueff：有效风速 effective wind speed
% 比例误差 0.143：https://rmets.onlinelibrary.wiley.com/doi/10.1002/joc.8339
% 固定误差 0.354：https://www.sciencedirect.com/science/article/pii/S2352484723015603
speed_u = 0.143 * Wind.speed + 0.354;
% speed_u = Wind.speed_std; % 采用前后1小时的风速的标准差作为风速不确定度

if(strcmp(Item.gas, 'CO2'))
    % Cusworth,2023
    q1 = 1.05;
    q2 = 0.6;
    if(Wind.speed > 2.0)
        Wind.Ueff = q1 * log(Wind.speed) + q2; % 单位：m/s
        Wind.Ueff_uncertainty = q1 * speed_u / Wind.speed; % 不确定度估算
    else % 低风速情况 IME估算不准确：参考2018 Varon文章
        Wind.Ueff = 0.29 * Wind.speed + 0.75;
        Wind.Ueff_uncertainty =  0.29 * speed_u; % 不确定度估算
    end

elseif(strcmp(Item.gas, 'CH4'))
    % Guanter,2021
    q1 = 0.34;
    q2 = 0.44;
    Wind.Ueff = q1 * Wind.speed + q2; % 单位：m/s
    Wind.Ueff_uncertainty = q1 * speed_u; % 不确定度估算
end

%%
fprintf('风向：'); cprintf(-[0,0.1,0.8], [num2str(round(Wind.direction)),'度\t ']);
fprintf('风速：'); cprintf(-[0,0.1,0.8], [num2str(round(Wind.speed, 2)),'m/s\n'])
lat = Item.latitude;
lon = Item.longitude;
llh = [lat, lon, 0];
pixel_position = RS_read_rpb(Item.flist.SWIR_rpb, llh);
Wind.rowIndex = round(pixel_position(1));
Wind.colIndex = round(pixel_position(2));
%% 读取地表压强数据
% SurfacePressure_filename = fullfile(filepath, ['SurfacePressureStruct_', num2str(choice), '.mat']);
% if(~exist(SurfacePressure_filename, 'file'))
%     % Wind = WebWindData(Item, choice);
%     surface_pressure_struct_data = WebSurfacePressureStructData(Item);
%     save(SurfacePressure_filename, 'surface_pressure_struct_data');
%     mydisp('正在保存地表压强STRUCT数据!');
% else
%     load(SurfacePressure_filename, 'surface_pressure_struct_data');
% end
% %% 解析STRUCT数据
% surface_pressure = surface_pressure_struct_data.hourly.surface_pressure;
% Hour = hour(Item.datetime);
% Minute = minute(Item.datetime);
% index = round(Hour + (Minute / 60)) + 1;
% SP = surface_pressure(index);
% g = 9.80665;
% VMA_sp = SP * 1e2 / g; % 该方法计算结果与ERA5结果偏差在2%左右
end