function [dstPoints, epsg_code] = LatLonToXY(pixel_ll)
    % LatLonToXY 将经纬度转换为平面坐标系坐标（米）
    % 输入:
    %   pixel_ll: 一个 nx2 的矩阵，第一列为纬度 (度)，第二列为经度 (度)
    % 输出:
    %   x: x 坐标 (米)
    %   y: y 坐标 (米)

    % 获取纬度和经度
    lat = pixel_ll(:, 1);
    lon = pixel_ll(:, 2);

    %% UTM
    % 判断南北半球
    if mean(lat) >= 0
        hemisphere = 'N';
    else
        hemisphere = 'S';
    end

    % 计算 UTM 带
    zones = floor((lon + 180) / 6) + 1;

    % 确保所有点使用相同的带
    zone = mode(zones); % 选择出现次数最多的带

    % 根据南北半球构建 EPSG 代码
    if hemisphere == 'N'
        epsg_code = 32600 + zone; % 北半球
    else
        epsg_code = 32700 + zone; % 南半球
    end
    % 创建投影对象
    proj = projcrs(epsg_code); 
    
    % 经纬度转平面坐标
    [x, y] = projfwd(proj, lat, lon); % X: 东 ； Y：北 

    dstPoints = [y, x];
end
