function InversionData(Item, band_data, PARM_INPUT, k_unit, force)
    % 默认不强制重新处理
    if nargin < 5 || isempty(force)
        force = false;
    end

    % 如果'强制'选项为true 或者 结果文件不存在，则进行反演
    if force || ~exist(Item.tiffname.RMF, 'file') || ~exist(Item.tiffname.RGB, 'file')
        FWHM_SWIR = Read_Raw(Item.flist.swir_fwhm, 2); % FWHM 包含central wavelength 中心波长 和 full width at half maxima 半宽
        bandindex = GetBandIndex(band_data, Item.xmlStruct.SatelliteID, FWHM_SWIR);
        swir_inv = ReadSWIR(Item.path.tempdata_path, Item.flist, bandindex);
        cw_inv = FWHM_SWIR(bandindex, 1);
        
        %% RGB
        FWHM_VNIR = Read_Raw(Item.flist.vnir_fwhm, 2);
        rgb = ReadDataRGB(Item.path.tempdata_path, Item.flist, FWHM_VNIR); % 读取RGB
        
        %% 气体吸收系数
        alti = Item.altitude / 1e3;
        [~, idx_h] = min(abs(alti - PARM_INPUT.HEIGHT));
        col = idx_h + 2;
        k_ = k_unit.(Item.xmlStruct.SatelliteID);
        k_ = k_(bandindex, col);
        amf = double(1 + 1 / cos(str2double(Item.xmlStruct.SolarZenith) / 180 * pi));
        % k_ = k_ * amf / 2;
        
        %% 匹配滤波算法
        IsAC = false; % 不使用albedo factor矫正
        swir_inv = PreProcessSWIR(swir_inv);
        swir_unit = ConvertUnit(swir_inv, cw_inv); % 单位转换为 W/(cm2×Sr×cm-1)
        result_RMF = RMF(swir_unit, k_, IsAC);
        
        %% TIFF 数据
        [rgb, result_RMF] = CheckSize(rgb, result_RMF); % 检查尺寸是否一致
        rgb = rgb / 256; 
        rgb_s = ImgStretch(rgb, 0.5, 99.5); % 拉伸RGB色彩
        rgb_t = color_AHSI(rgb_s);
        ExportResultTIFF(rgb_t, Item.flist.SWIR_rpb, Item.tiffname.RGB);
        ExportResultTIFF(result_RMF, Item.flist.SWIR_rpb, Item.tiffname.RMF); % 导出结果
        disp('已输出结果文件');
        disp(Item.tiffname.RGB);
        disp(Item.tiffname.RMF);
    else
        % 数据已存在，不进行任何操作
        disp('结果文件已存在，跳过处理。如果需要重新处理，请设置''force''参数为true。');
    end
end