function [rindexs, cindexs] = InterestArea(data, Facility, flist, range)
%% 基本信息
[ROW, COL, ~] = size(data);
%% 查找排放源坐标
lat = Facility.lat;
lon = Facility.lon;
llh = [lat, lon, 0];
pixel_position = RS_read_rpb(flist.SWIR_rpb, llh);
rowIndex = round(pixel_position(1));
colIndex = round(pixel_position(2));
mydisp(sprintf("行索引：%d 列索引：%d", rowIndex, colIndex));

%% 裁剪范围
if(rowIndex - range + 1 <= 0)
    r1 = 0;
else
    r1 = rowIndex - range + 1;
end
if(rowIndex + range >= ROW)
    r2 = ROW;
else
    r2 = rowIndex + range;
end
rindexs = r1:r2;
if(colIndex - range + 1 <= 0)
    c1 = 0;
else
    c1 = colIndex - range + 1;
end
if(colIndex + range >= COL)
    c2 = COL;
else
    c2 = colIndex + range;
end
cindexs = c1:c2;

end