function stretchedImage = ImgStretch(img, a, b)
% 输入参数：
% img: RGB图像
% a: 最小截断百分比
% b: 最大截断百分比
% 将图像矩阵转换为向量
imgVector = cell(3, 1);
stretchedImage = zeros(size(img));
for k = 1 : 3
    imgVector{k} = reshape(img(:, :, k), [], 1);
    % 计算拉伸的最小和最大像素值
    min_value(k) = prctile(imgVector{k}, a);
    max_value(k) = prctile(imgVector{k}, b);
    % 对图像进行百分比截断拉伸
    stretchedImage(:,:,k) = (img(:, :, k) - min_value(k)) ./ (max_value(k) - min_value(k));
end

% 将图像值限制在 [0, 1] 范围内
stretchedImage = max(0, min(1, stretchedImage));
end