function ImageBrowser(T, len, Root_Path1, Root_Path2, prefix)
    % 创建一个新的 figure 窗口作为应用程序的基础
    fig = uifigure('Name', 'Image Browser');
    fig.Position = [50, 50, 1400, 950]; % 增加窗口高度以容纳标题

    % 创建一个轴对象用于显示图像，并增大其尺寸
    ax = uiaxes(fig);
    ax.Position = [25, 25, 1350, 900]; % 调整位置和大小以适应更大的窗口

    % 初始化索引和其他变量
    persistent i Item % 使用 persistent 保持索引和当前项的状态
    if isempty(i) || isempty(Item)
        i = 1;
        Item = GetFacilityData(T, i);
        Item = prepare_basis(Root_Path1, Root_Path2, Item);
    end
    
    % 定义更新图像的内部函数
    function updateImage()
        figname = fullfile(Item.path.result_path, [prefix, Item.foldername, '_Profile.png']);
        imshow(figname, 'Parent', ax, 'InitialMagnification', 'fit'); % 使用 fit 自动调整图像大小
        title(ax, sprintf('Image Index: %d', i)); % 设置标题为序号 i
    end

    % 显示第一个图像
    updateImage();

    % 创建“后退”按钮
    backButton = uibutton(fig, 'push', 'Text', '<-', 'Position', [50, 50, 50, 22]);
    backButton.ButtonPushedFcn = @(btn,event) updateImageOnButtonPress(-1);

    % 创建“前进”按钮
    forwardButton = uibutton(fig, 'push', 'Text', '->', 'Position', [1100, 50, 50, 22]);
    forwardButton.ButtonPushedFcn = @(btn,event) updateImageOnButtonPress(1);

    % 定义更新图像的辅助函数
    function updateImageOnButtonPress(direction)
        i = mod(i + direction - 1, len) + 1; % 更新索引，并处理循环
        Item = GetFacilityData(T, i);
        Item = prepare_basis(Root_Path1, Root_Path2, Item);
        updateImage(); % 更新显示的图像
    end

    % 添加键盘事件监听器
    fig.WindowKeyPressFcn = @(src,event) handleKeyPress(event);

    % 定义键盘事件处理函数
    function handleKeyPress(event)
        switch event.Key
            case 'rightarrow' % 右箭头
                updateImageOnButtonPress(1);
            case 'uparrow' % 上箭头
                updateImageOnButtonPress(1);
            case 'leftarrow' % 左箭头
                updateImageOnButtonPress(-1);
            case 'downarrow' % 下箭头
                updateImageOnButtonPress(-1);
        end
    end
end