function Q = calc_emission(TIFF, Wind, IME)
%% 排放信息计算
L = sqrt( sum(TIFF.finalmask(:)) ) * TIFF.unit_length; % 羽流尺寸 plume size 单位：m
tau = L / Wind.Ueff; % 排放时间 单位： s
tau_u = L * Wind.Ueff_uncertainty / (Wind.Ueff ^ 2); % 不确定度
%% 排放速度
if(tau ~= 0)
    Q.kg_s = IME.data / tau;   % 单位 kg/s
    Q.inversion_u = (IME.uncertainty * tau) / (tau ^ 2) * 3600 / 1000;
    Q.wind_u = (IME.data * tau_u) / (tau ^ 2) * 3600 / 1000;
    Q.kg_s_u = ((IME.data * tau_u) + (IME.uncertainty * tau)) / (tau ^ 2); % 不确定度
else
    Q.kg_s = 0;
    Q.kg_s_u = 0;
end
Q.st_h = Q.kg_s * 3600 / 907.181474;  % 单位 st/h
Q.kg_h = Q.kg_s * 3600; % 单位 kg/h
Q.kg_h_u = Q.kg_s_u * 3600;
Q.ton_h = Q.kg_s * 3600 / 1000;  % 单位 ton/h
Q.ton_h_u = Q.kg_s_u * 3600 / 1000;
%%
Q.L = L;
Q.V = Wind.speed;
end