%% 计算IME含量
function IME = calc_IME(TIFF, VMA, GasType)
if(strcmp(GasType, 'CO2'))
    M_GAS = 44.01;     % 二氧化碳的摩尔质量
elseif(strcmp(GasType, 'CH4'))
    M_GAS = 16.043;     % 甲烷的摩尔质量
end
M_dry = 28.9647;    % 干空气的摩尔质量
% 计算整体质量增量
Integral_mass_add = M_GAS / M_dry * VMA.interpdata * TIFF.finaldata * 1e-6; % 单位 kg m-2
Integral_mass_add_u = M_GAS / M_dry * VMA.interpdata * TIFF.finaldata_u * 1e-6; % 不确定度
IME.data = sum(Integral_mass_add(:)) * (TIFF.unit_length ^ 2); % 单位 kg
N = sum(Integral_mass_add(:) > 0); % 累加的总数
IME.uncertainty = sqrt(N) * Integral_mass_add_u * (TIFF.unit_length ^ 2); % 误差传递公式
% fprintf("CO2整体质量增量为：%.2fkg\n", IME.data);
end
