% Date: 2023-12-17
% Author: HuayiWang
function struct_data = WebWindData(Item, choice)
%% 获取基本信息
lat = Item.latitude;
lon = Item.longitude;
Date = datestr(Item.datetime, 'yyyy-mm-dd');

%% 定义API链接
options = weboptions('Timeout', 60);
api_url_head = 'https://archive-api.open-meteo.com/v1/archive?';
geo_info = ['latitude=', num2str(lat), '&longitude=', num2str(lon)];
time_info = ['&start_date=', Date, '&end_date=', Date];
data_info = '&hourly=wind_speed_10m,wind_direction_10m,wind_speed_100m,wind_direction_100m&wind_speed_unit=ms&timezone=GMT';
% 用的是10m风速和风向
model_name = {'era5_seamless', 'ecmwf_ifs', 'best_match'};
model_info = ['&models=', model_name{choice}];
api_url = [api_url_head, geo_info, time_info, data_info, model_info];

%% 使用webread获取API返回的JSON数据
max_attempts = 5;  % 设置最大尝试次数
current_attempt = 1;

while current_attempt <= max_attempts
    try % 成功获取数据
        struct_data = webread(api_url, options);
%         mydisp('风速数据成功获取！');
        break;  % 跳出循环，因为已成功获取数据
    catch
        % 如果发生错误，捕获异常并显示错误消息
        disp(['尝试 ', num2str(current_attempt), ' 失败，等待重试...']);
        current_attempt = current_attempt + 1;
        pause(3);  % 添加3秒的延迟
    end
end
end
