function PlotWind(Wind)
theta_0 = calc_theta(Wind.direction);
alpha = deg2rad(theta_0);
theta = [0 alpha];
rho = [0 Wind.speed];
% 绘制风速图并设置线条宽度为2
polarplot(theta, rho, 'LineWidth', 2, 'Color', 'k');
hold on;
offset_angle = deg2rad(20); % 短线与风向的夹角
% 绘制与风向成15°夹角的短线
short_line_length = rho / 8; % 短线长度为风速的1/10
% 确定短线起点和终点的角度
start_angle = alpha + offset_angle;
end_angle = alpha - offset_angle;

% 绘制两条短线
polarplot([0 start_angle], short_line_length, 'LineWidth', 2, 'Color', 'k');
polarplot([0 end_angle], short_line_length, 'LineWidth', 2, 'Color', 'k');


thetaticks([0 45 90 135 180 225 270 315])
thetaticklabels({'E', 'NE', 'N', 'NW', 'W', 'SW', 'S', 'SE'})
% 在风矢量末端添加文本标签
text(alpha, Wind.speed, sprintf('%.1f m/s\n%.0f°', Wind.speed, Wind.direction), ...
    'VerticalAlignment', 'bottom', ... % 文本垂直对齐方式
    'HorizontalAlignment', 'center', ... % 文本水平对齐方式
    'FontName', 'Arial', ...
    'FontSize', 14); % 设置字体大小
% 设置字体大小和字体名称
set(gca, 'FontName', 'Arial', 'FontSize', 14);
% 显示网格
grid on;
set(gca, 'GridColor', [0.1 0.1 0.1]);
hold off;
end

function theta_0 = calc_theta(alpha)
if(alpha>=0 && alpha < 90)
    theta_0 = 90 - alpha;
elseif(alpha>=90 && alpha < 180)
    theta_0 = 360 - (alpha - 90);
elseif(alpha>=180 && alpha < 270)
    theta_0 = 360 - (alpha - 90);
elseif(alpha>=270 && alpha <= 360)
    theta_0 = 360 - (alpha - 90);
else
    disp('ERR!');
end
end