%% 绘图（总）
function Myplot(Wind, TIFF)
caxis_num = [0 80];
%% 绘图
figure('Position', [20 300 1400 300])
%% plot1
% 绘制风向箭头
subplot(151)
PlotWind(Wind);
%% plot2
% 绘制RGB图像
subplot(152)
imshow(TIFF.cutrgb);
hold on
% 绘制排放源位置
plot(TIFF.rowIndex, TIFF.colIndex, 'w.','MarkerSize', 15);
hold off
axis square
%% plot3
subplot(153)
imagesc(TIFF.cutdata);
axis square
axis off
caxis(caxis_num)
%% plot4
subplot(154)
imagesc(TIFF.data);
axis square
axis off
caxis(caxis_num)
%% plot5
subplot(155)
imshow(TIFF.cutrgb);
hold on
h = imagesc(TIFF.data);
axis square
caxis(caxis_num)
% 找到 0 值的位置并设置为透明
zerosIndices = TIFF.data == 0;
set(h, 'AlphaData', ~zerosIndices);
% 绘制排放源位置
plot(TIFF.rowIndex, TIFF.colIndex, 'w.','MarkerSize', 15);
hold off

%% colorbar
hColorBar = colorbar;
cmap = mycolorbar(2); % 输入参数为数字，表示选择不同的colormap
colormap(cmap);
ylabel(hColorBar, '$$\delta\mathrm{CO}_2 \, (\mathrm{ppm})$$', 'Interpreter', 'latex');
% 调整colorbar的位置（可根据需要调整）
set(hColorBar, 'Position', [0.95 0.2 0.01 0.6]);
% 移动 ylabel 到左侧
set(get(hColorBar,'YLabel'), 'Position', get(get(hColorBar,'YLabel'), 'Position') - [4 0 0]);

end
