% 读取图像并进行裁剪工作
function TIFF_out = CutFromTIFF(TIFF_in, cut_info_dir, Is_First_Cut, ifshow)
%% 裁剪文件名称
Area_file = ['CUT_area_', TIFF_in.foldername, '.mat'];
cut_file = fullfile(cut_info_dir, Area_file);

%% 数据赋值
image = TIFF_in.cutrgb;
gasdata = TIFF_in.maskdata;

%% 显示图像
figure('Position', [700 200 700 700], 'visible', ifshow);
imshow(TIFF_in.cutrgb, 'InitialMagnification', 'fit');
hold on
h = imagesc(gasdata);
axis square
axis tight;
%
clim([0 min([60, max(TIFF_in.maskdata(:))])])
cmap = mycolorbar(5);
colormap(gca, cmap);  % 使用颜色映射
colorbar
% 找到 0 值的位置并设置为透明
zerosIndices = gasdata == 0;
set(h, 'AlphaData', ~zerosIndices);

% 绘制排放源位置
plot(TIFF_in.rowIndex, TIFF_in.colIndex, 'w.','MarkerSize', 15);
%% 判断是否进入裁剪
if(Is_First_Cut) % 如果是首次进入裁剪程序
    % 先尝试加载过去的文件
    if(exist(cut_file, 'file')) % 如果存在已经裁剪好的范围
        load(cut_file, 'area'); % 从文件加载多边形范围变量
%         mydisp("正在加载已经裁剪好的范围")
    else % 首次裁剪，但没有保存过的文件
        area = Main_Cut_Tiff(TIFF_in); % 裁剪主程序
    end
    
else % 本次非首次裁剪
    area = Main_Cut_Tiff(TIFF_in); % 裁剪主程序
end


%% 生成图像上所有像元的坐标
[xx, yy] = meshgrid(1:size(image, 2), 1:size(image, 1));
% 获取封闭图形内部的像元
xCut = area(:, 1) + TIFF_in.rowIndex;
yCut = area(:, 2) + TIFF_in.colIndex;
inPolygon = inpolygon(xx(:), yy(:), xCut, yCut);
inPolygon = reshape(inPolygon, size(image, [1 2]));
gasdata(~inPolygon) = 0; % 裁剪范围之外的数值设置为0，表示没有浓度增强
mask = inPolygon;
%% 二值提取
% neighbour = 8; % 使用四邻域处理
% % 使用二值图像标记连通区域
% labeled_image = bwlabel(mask2, neighbour); % 使用 4-邻域连接法则标记连通区域
% region_props = regionprops(labeled_image, 'Area'); % 获取各个区域的像素数目
% % 仅保留像素数目达到 thresh 个的部分
% mask3 = ismember(labeled_image, find([region_props.Area] >= 3));
% mask3data = gasdata .* mask3; % 筛选结果

%% 重绘图形
title([TIFF_in.name,' ', TIFF_in.datestr]); % 图名
imshow(TIFF_in.cutrgb, 'InitialMagnification', 'fit');
h1 = imagesc(gasdata);
colormap(gca, cmap);  % 使用颜色映射
% 找到 0 值的位置并设置为透明
zerosIndices = (gasdata == 0);
set(h1, 'AlphaData', ~zerosIndices);
% 绘制排放源位置
plot(TIFF_in.rowIndex, TIFF_in.colIndex, 'w.','MarkerSize', 15);
axis square
axis tight;
%% 绘制裁剪多边形相关内容
plot(xCut, yCut, 'b-', 'LineWidth', 1); % 蓝色边线
patch(xCut, yCut, 'w', 'FaceAlpha', 0.1); % 白色透明面
scatter(xCut, yCut, 10, 'r', 'filled'); % 标注每个点为红色实心圆
hold off
%% 数据赋值
TIFF_out = TIFF_in;
TIFF_out.area = area;
TIFF_out.finalmask = gasdata > 0;
TIFF_out.finaldata = TIFF_out.finalmask .* TIFF_in.cutdata;
TIFF_out.finaldatashow = TIFF_out.finalmask .* TIFF_in.maskdata;
TIFF_out.cutmask = mask;
%% 数据保存
save(cut_file, 'area');
end



%% 裁剪主程序
function area = Main_Cut_Tiff(TIFF)
title([TIFF.name,' ', TIFF.datestr]); % 图名
% 初始化坐标数组
xSelected = NaN(99, 1);
ySelected = NaN(99, 1);
% 循环手动选择点，按回车键或者鼠标右键结束
point_num = 0;
while true
    [x, y, button] = ginput(1); % 一次只获取一个点
    % 如果按下回车键，结束循环
    if isempty(button) || button == 13 || button == 3
        break;
    end
    point_num = point_num + 1;
    % 将选择的点添加到数组中
    xSelected(point_num) = x;
    ySelected(point_num) = y;
    % 更新图形，实时显示选择的点
    plot(xSelected, ySelected, 'b-', 'LineWidth', 1);
    scatter(xSelected, ySelected, 10, 'r', 'filled'); % 标注每个点为红色实心圆
end

% 将第一个点添加到末尾以构成封闭曲线
point_num = point_num + 1;
xSelected(point_num) = xSelected(1);
ySelected(point_num) = ySelected(1);

% 取前point_num项
xSelected = xSelected(1 : point_num);
ySelected = ySelected(1 : point_num);

% 赋值给area
area = [xSelected - TIFF.rowIndex, ySelected - TIFF.colIndex];
end