%% 检查卫星和设施数据是否匹配
function CheckSatelliteANDFacility(Satellite, Facility)
is_inside = CheckPosition(Satellite, Facility); % 检查卫星与设施的坐标是否匹配
is_samename = strcmp(Facility.Satellite, Satellite.name); % 检查卫星名称
is_sametime1 = abs(Facility.UTC_time - Satellite.time) < minutes(1);
is_sametime2 = abs(Facility.satllite_time - Satellite.time) < minutes(1);
is_sametime = is_sametime1 || is_sametime2;
if(~is_inside || ~is_samename || ~is_sametime)
    mydisp("ERROR！！！卫星与设施基本信息不匹配！请检查代码！")
else
    mydisp("卫星与设施基本信息匹配准确。")
end
% 子函数：判断电厂设施与卫星影像范围是否匹配
    function is_inside = CheckPosition(Satellite, Facility)
        % 判断当前点是否在该卫星影像范围之内
        lats = [Satellite.TopLeftLatitude, Satellite.TopRightLatitude, Satellite.BottomRightLatitude, Satellite.BottomLeftLatitude];
        lons = [Satellite.TopLeftLongitude, Satellite.TopRightLongitude, Satellite.BottomRightLongitude, Satellite.BottomLeftLongitude];
        is_inside = inpolygon(Facility.lon, Facility.lat, lons, lats);
        if(~is_inside)
            disp("该卫星影像与该设施地理位置不匹配！")
            return;
        end
    end
end