%% 获取排放设施基本信息
function Item = GetFacilityDataNew(Table, index)
Item.id = Table{index, 'id'}; % 序号
Item.filename = char(Table{index, 'filename'}); % 数据名称
Item.foldername = char(Table{index, 'foldername'}); % 子文件夹名称
underIndices = strfind(Item.foldername, '_'); % 获取下划线索引
Item.region = Item.foldername(1 : underIndices(1) - 1); % 地区名称
Item.facility = char(Table{index, 'facility'}); % 设施的名称
Item.type = char(Table{index, 'type'}); % 设施源的类型
Item.lat = Table{index, 'Latitude'}; % 设施的纬度
Item.lon = Table{index, 'Longitude'}; % 设施的经度
Item.satellite = char(Table{index, 'satellite'}); % 观察设施的卫星
Item.date = char(Table{index, 'date'}); % 日期
Item.satellite_time = datetime(Table{index, 'Time of Satellite'}); % 卫星时间
Item.UTC = datetime(Table{index, 'UTC'}); % UTC时间
Item.LST = datetime(Table{index, 'Local Standard Time'}); % 当地时间
Item.emission = Table{index, '排放'}; % 排放
end

