%% 获取排放设施基本信息
function Item = GetFacilityData(T, index)
    % 初始化结构体
    Item = struct();
    % 字段名称
    fields = T.Properties.VariableNames;

    % 循环遍历每个字段
    for i = 1:length(fields)
        fieldName = fields{i};
        
        % 对于字符串类型的数据使用char转换
        if iscellstr(T.(fieldName))
            Item.(fieldName) = char(T{index, fieldName});
        else
            Item.(fieldName) = T{index, fieldName};
        end
        
        % 特殊处理日期时间字段
        if strcmp(fieldName, 'datetime') || strcmp(fieldName, 'local_datetime')
            Item.(fieldName) = datetime(char(T{index, fieldName}), 'InputFormat', 'yyyy-MM-dd HH:mm:ss');
        end
    end

    if(Item.plume_quality == 1)
        Item.plume_quality_label = 'High Confidence';
    elseif(Item.plume_quality == 0.7)
        Item.plume_quality_label = 'Medium Confidence';
    elseif(Item.plume_quality == 0.5)
        Item.plume_quality_label = 'Low Confidence';
    elseif(Item.plume_quality ==0)
        Item.plume_quality_label = 'No Emission';
    elseif(Item.plume_quality == -1)
        Item.plume_quality_label = 'Not Quantifiable';
    else
        Item.plume_quality_label = 'Unlabeled';
    end

    % 获取folder前缀
    underIndices = strfind(Item.foldername, '_'); % 获取下划线索引
    Item.region = Item.foldername(1 : underIndices(1) - 1); % 地区名称
end