function FitUeffPlot(T)
select_idx = T.plume_quality >= 0.7;
fit_x = T.wind_speed(select_idx);
fit_y = T.wind_fit(select_idx);
% 双重筛选
% select_idx2 = T.wind_speed < 2;
% fit_x_2 = T.wind_speed(select_idx & select_idx2);
% fit_y_2 = wind_fit(select_idx & select_idx2);
[xData, yData] = prepareCurveData(fit_x, fit_y);
% 设置 fittype 和选项。
ft = fittype('poly1'); % 线性拟合

[fitresult, gof] = fit(xData, yData, ft); % 初次拟合
residuals = fitresult(xData) - yData; % 计算残差
threshold = 3 * std(residuals); % 确定阈值（例如，2个标准差）
outlierIndices = abs(residuals) > threshold; % 找到离群点索引

% 移除离群点
xDataFiltered = xData(~outlierIndices);
yDataFiltered = yData(~outlierIndices);

[fitresultFiltered, gofFiltered] = fit(xDataFiltered, yDataFiltered, ft); % 再次拟合

% 创建一个新的图形窗口，并设置大小
figure('Position', [200 100 800 700]);
hold on;
% 绘制原始散点图
scatter_obj  = scatter(xData, yData);
% 设置散点的颜色
set(scatter_obj, 'MarkerFaceColor', [0.5 0.6 1], 'MarkerEdgeColor', 'k');

% 绘制离群点
scatter_obj2 = scatter(xData(outlierIndices), yData(outlierIndices), 'filled'); % 红色表示离群点
% 设置散点的颜色
set(scatter_obj2, 'MarkerFaceColor', [1 0.4 0.4], 'MarkerEdgeColor', 'k');

% 绘制去除离群点后的拟合直线
plot(xDataFiltered, fitresultFiltered(xDataFiltered), 'Color', [0.4940, 0.1840, 0.5560], 'LineWidth', 2); % 深紫色实线表示去除离群点后的拟合
% 设置拟合线的样式和颜色
line_obj = findobj(gca, 'Type', 'line'); % 找到拟合线的对象
set(line_obj, ...
    'LineStyle', '--', ...              % 设置拟合线为虚线
    'Color', [0 0.4470 0.7410]);        % 设置拟合线的颜色

% 为坐标轴加标签，并设置字体属性
xlabel('U10 (m/s)', 'FontName', 'Arial', 'FontSize', 16);
ylabel('Ueff (m/s)', 'FontName', 'Arial', 'FontSize', 16);

% 显示网格
grid on;
box on;
% 设置图形元素的字体属性
set(gca, 'FontName', 'Arial', 'FontSize', 16, ...
    'XGrid', 'on', 'YGrid', 'on', ... % 确保网格可见
    'GridAlpha', 0.3);                % 设置网格透明度

% 在图中添加文本框来展示最终拟合的 R-squared 值和公式
annotation('textbox', [0.15 0.8 0.2 0.1], ...
    'String', sprintf('R^2 = %.4f\ny = %.2fx + %.2f', ...
    gofFiltered.rsquare, ...
    fitresultFiltered.p1, ...
    fitresultFiltered.p2), ...
    'FitBoxToText', 'on', ...
    'FontSize', 14, ...
    'FontName', 'Arial', ...
    'EdgeColor', 'none');
hold off;
end