function ExportResultTIFF(image, SWIR_rpb, OutputName)
%% 中间文件导出
merge_out = flipud(image);
Ref = georasterref('RasterSize', size(image, 1:2), 'Latlim',[-90, 90], 'Lonlim',[-180, 180]);
TempFile = fullfile(pwd, 'temptif.tif');
geotiffwrite(TempFile, merge_out, Ref);
%% 几何精校正
cd('functions/georpc')
obj = py.importlib.import_module('geo_rpc_copy'); % 导入python模块
py.importlib.reload(obj);   % 重新加载模块
py.geo_GCP.geoGCP(TempFile, OutputName, SWIR_rpb)
% mydisp("几何精校正完成");
delete(TempFile); % 清除中间文件
clear obj; % 清除PYTHON变量
cd('../..')
end