import pandas as pd
import cdsapi
import os
import shutil
import math
from concurrent.futures import ThreadPoolExecutor

def Get_Mass(date, Facility, lat, lon):
    # 将Timestamp对象转换为日期和时间的字符串
    date_str = date.strftime("%Y-%m-%d")
    time_str_0 = (date - pd.Timedelta(hours=1)).strftime("%H:00")
    time_str_1 = date.strftime("%H:00")
    time_str_2 = (date + pd.Timedelta(hours=1)).strftime("%H:00")
    time_str_3 = (date + pd.Timedelta(hours=2)).strftime("%H:00")

    # 解析日期字符串
    date_parts = date_str.split('-')
    year, month, day = date_parts

    # 计算包含位置的上下左右取整格网
    lat_min = math.floor(lat)
    lat_max = lat_min + 1
    lon_min = math.floor(lon)
    lon_max = lon_min + 1

    # 构建文件名
    filename = f'{Facility}_{year}{month}{day}_PL.nc'

    # 初始化 CDS API 客户端
    c = cdsapi.Client()

    # 构建参数并调用 CDS API
    c.retrieve(
        'reanalysis-era5-pressure-levels',
        {
            'product_type': 'reanalysis',
            'variable': ['u_component_of_wind', 'v_component_of_wind'],
            'pressure_level': '1000',
            'year': year,
            'month': month,
            'day': day,
            'time': [time_str_0, time_str_1, time_str_2, time_str_3],
            'area': [lat_max, lon_min, lat_min, lon_max],  # 修正顺序
            'format': 'netcdf',
        },
        filename
    )
    return filename


def process_row(row):
    date = row['UTC']
    Facility = row['Facility Name']
    lat = row['Latitude']
    lon = row['Longitude']
    foldername = row['foldername']

    search_file_path = os.path.join(file_path_0, foldername)
    Files = os.listdir(search_file_path)

    date_str = date.strftime("%Y-%m-%d")
    date_parts = date_str.split('-')
    year, month, day = date_parts
    filename = f'{Facility}_{year}{month}{day}_PL.nc'

    if filename in Files:
        print(f"{foldername} already has nc file")
    else:
        filename = Get_Mass(date, Facility, lat, lon)

        target_folder = os.path.join(file_path_0, foldername)

        target_file_path = os.path.join(target_folder, filename)
        source_file_path = os.path.join('./', filename)

        if os.path.exists(source_file_path):
            shutil.move(source_file_path, target_file_path)
            print(f"File successfully moved to target subdirectory: {target_folder}")
        else:
            print(f"File does not exist: {source_file_path}")

file_path_0 = r"F:\科研数据\2024.2 美国核查结果"
file_path = r'C:\Users\why\Desktop\CO2_匹配滤波器\data\美国碳源反演.xlsx'
sheet_name = '2024.2'
data = pd.read_excel(file_path, sheet_name=sheet_name)

# 创建ThreadPoolExecutor对象，线程数为4
with ThreadPoolExecutor(max_workers=40) as executor:
    # 提交每行数据的处理
    futures = [executor.submit(process_row, row) for _, row in data.iterrows()]

    # 等待所有任务完成
    for future in futures:
        future.result()
