import os
import shutil

def move_files_to_subfolder(base_path):
    # 遍历base_path下的所有文件和文件夹
    for root, dirs, files in os.walk(base_path):
        for file in files:
            if file.endswith('_SL.nc'):
                # 分析文件名以获取目标文件夹名称
                parts = file.split('_')
                if len(parts) > 1:
                    facility = parts[0]
                    target_subfolder = os.path.join(root, facility)

                    # 创建子文件夹（如果不存在）
                    if not os.path.exists(target_subfolder):
                        os.makedirs(target_subfolder)

                    # 移动文件到子文件夹
                    source_file_path = os.path.join(root, file)
                    target_file_path = os.path.join(target_subfolder, file)

                    shutil.move(source_file_path, target_file_path)
                    print(f"Moved {file} to {target_subfolder}")

# 设置你的base_path路径
base_path = r"E:/2024.7 中国水泥核查结果"

# 执行移动操作
move_files_to_subfolder(base_path)
