import os
import shutil

def correct_nested_files(base_path):
    # 遍历 base_path 下的所有文件和文件夹
    for root, dirs, files in os.walk(base_path):
        for dir_name in dirs:
            subdir_path = os.path.join(root, dir_name)
            # 如果子文件夹的名称与父文件夹名称相同
            if os.path.basename(root) == dir_name:
                nested_files_path = subdir_path
                # 将嵌套文件移回上一级文件夹
                for nested_file in os.listdir(nested_files_path):
                    nested_file_path = os.path.join(nested_files_path, nested_file)
                    target_path = os.path.join(root, nested_file)
                    shutil.move(nested_file_path, target_path)
                    print(f"Moved {nested_file} to {root}")

                # 删除多余的子文件夹
                os.rmdir(nested_files_path)
                print(f"Removed empty folder {nested_files_path}")

# 设置你的 base_path 路径
base_path = r"E:/2024.7 中国水泥核查结果"

# 执行文件修正操作
correct_nested_files(base_path)
