function [Q, TIFF_out, IME] = CutTIFFByHand(TIFF_in, VMA, Wind, result_file_path, skip, ifshow, GasType)
IsOK = false; % 是否裁剪完成
IsFirstCut = true; % 是否第一次裁剪
cut_info_dir = fullfile(result_file_path, 'CUT');
if(~exist(cut_info_dir, 'dir')) % 如果不存在output文件夹
    mkdir(cut_info_dir) % 新建文件夹
end
while(~IsOK)
    TIFF_out = CutFromTIFF(TIFF_in, cut_info_dir, IsFirstCut, ifshow);
    %%
    IME = calc_IME(TIFF_out, VMA, GasType);    % 二氧化碳整体质量增量 integrated mass enhancement(IME)
    Q = calc_emission(TIFF_out, Wind, IME);    % 计算Emission的函数
    fprintf("手动提取: "); cprintf('*red',sprintf('%.2f±%.2f(t/h)\n', Q.ton_h, Q.ton_h_u));
    if(skip) % 如果跳过裁剪的话
        IsOK = true; % 跳过裁剪
    else
        IsOK = input("请输入是否完成：");
    end
    IsFirstCut = false;
end
end