function swir_2 = ConvertUnit(swir_, bandlength_1)
% swir_：辐射定标后的辐亮度单位为：W·m-2·sr-1·μm-1
% 气体吸收系数的单位： W/(cm2×Sr×cm-1)
% bandlength： 波长，以nm为单位
bandwavnum_1 = 1e7 ./ bandlength_1; % 波长转波数：nm->cm-1 ;
bandwavenum_2 = shiftdim(bandwavnum_1, -2); % cm-1
bandwavnum_2 = repmat(bandwavenum_2, size(swir_, [1 2])); % cm-1
bandlength_1 = shiftdim(bandlength_1, -2); % nm
bandlength_2 = repmat(bandlength_1, size(swir_, [1 2])) / 1e3; % μm

swir_2 = swir_ .* bandlength_2 ./ bandwavnum_2; % W/(m2×Sr×cm-1)
swir_2 = swir_2 * 1e-4; % W/(cm2×Sr×cm-1)
end